library IEEE;
use IEEE.std_logic_1164.all;

entity  clk_div is 
generic(COUNT: INTEGER range 0 to 655350);
port(
		CLK_IN	: in std_logic; 
		SM_CLK	: out std_logic); 
end clk_div;

architecture behavioral of clk_div is
signal clk_out : std_logic :='0';
begin

	process(CLK_IN)
		variable cnt : integer range 0 to 150000;
		variable clk_out : std_logic;				-- mark 
		
	begin
		if (CLK_IN'event and CLK_IN = '1') then
			if cnt < COUNT then
				cnt := cnt + 1;
			elsif cnt = COUNT then
				cnt := 0;
				clk_out := not clk_out;
			end if;
		end if;
		
		SM_CLK <= clk_out;
		
	end process;
end behavioral;