library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity D_DATE is
port(	clk			: in std_logic;
		increase	: in std_logic;
		hur_carry	: in std_logic;
		mode1		: in std_logic_vector(1 downto 0);
		mode2		: in std_logic_vector(1 downto 0);
		year		: out std_logic_vector(6 downto 0);
		mon			: out std_logic_vector(3 downto 0);
		day			: out std_logic_vector(5 downto 0));
end D_DATE;


architecture behav of D_DATE is 
signal inc_day	: std_logic;
signal inc_mon	: std_logic;
signal inc_yr	: std_logic;

begin
process(increase, mode1, mode2)
begin
	if increase= '1' and mode1="01" then		--Mode hari: Mode1=01
		inc_yr  <= not(mode2(1)) and mode2(0);	--Mode2=01 for yr
		inc_mon <= mode2(1) and not(mode2(0));	--Mode2=10 for mon
		inc_day <= mode2(1) and mode2(0);		--Mode2=11 for day
	else
		inc_yr  <= '0';
		inc_mon <= '0';
		inc_day <= '0';
	end if;
end process;


process(clk, inc_yr, inc_mon, inc_day)
variable v_secc	: std_logic_vector(6 downto 0):="0000000"; 	
variable v_yr	: std_logic_vector(6 downto 0):="0000000";	
variable v_mon	: std_logic_vector(3 downto 0):="0001";		
variable v_day	: std_logic_vector(5 downto 0):="000000";		




begin
	if rising_edge(clk) then
						

		if(hur_carry='1') then
			--v_day:=v_day+1;
			--hur_carry<='0';
			--mon check block: 31 day's month
			if (v_mon="0001" or v_mon="0011" or v_mon="1001" or v_mon="0111" or v_mon="1000" or v_mon="1010" or v_mon="1100") then
				--day check
				if (v_day="011111") then --31 
					v_mon:=v_mon+1;
					v_day:="000001";
				else
					v_day:=v_day+1;	
				end if;			
			elsif (v_mon="0010") then	--Feb check
				--day check
				if (v_day="011100") then --28
					v_mon:=v_mon+1;
					v_day:="000001";
				else
					v_day:=v_day+1;	
				end if;			
			--mon check: 30 day's month	
			elsif (v_mon="1000" or v_mon="0110" or v_mon="1001" or v_mon="1011") then
				--day check
				if (v_day="011110") then --30 
					v_mon:=v_mon+1;
					v_day:="000001";
				else
					v_day:=v_day+1;
				end if;	
			end if;
			
			--month check for 12 mon completed or not
			if (v_mon="1101") then --13
						v_yr:=v_yr+1;
						v_mon:="0001";
						if(v_yr="1100011") then		-- if 99 yr, set back to 00
							v_yr:="0000000";
						end if;
			end if;
			
		end if;
		
		--Mon: 31: 1,3,5,7,8,10,12
		--Mon: 30: 4,6,9,11
		--Mon: 28: 2 
		
			
		if(inc_yr='1') then
			if(v_yr="1100011")then  --99
				v_yr:="0000000";
			else
				v_yr:=v_yr+1;
			end if;
		elsif(inc_mon='1') then
			if(v_mon="1100")then	--12
				v_mon:="0001";
				v_yr:=v_yr+1;
			else
				v_mon:=v_mon+1;
			end if;
		elsif(inc_day='1') then
			-- 31 day's month??
			if (v_mon="0001" or v_mon="0011" or v_mon="1001" or v_mon="0111" or v_mon="1000" or v_mon="1010" or v_mon="1100") then
				if(v_day="011111") then  --31 
					v_day:="000001";
					v_mon:=v_mon+1;
				else
					v_day:=v_day+1;
				end if;
			elsif (v_mon="0010") then	--Feb check
				if(v_day="011100") then  --28 
					v_day:="000001";
					v_mon:=v_mon+1;
				else
					v_day:=v_day+1;
				end if;
			-- 30 day's month??
			elsif (v_mon="1000" or v_mon="0110" or v_mon="1001" or v_mon="1011") then
				if(v_day="011110") then  --30 
					v_day:="000001";
					v_mon:=v_mon+1;
				else
					v_day:=v_day+1;
				end if;
			end if;	
		end if;
	
		year<=v_yr;
		mon<=v_mon;
		day<=v_day;
	end if;
end process;
end behav;