library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity divider is
port(	div_in: in std_logic_vector(6 downto 0);	-- 7 bit
		div_ten: out std_logic_vector(3 downto 0);	-- 4 bit
		div_1: out std_logic_vector(3 downto 0));	-- 4 bit
end divider;

architecture beh of divider is 
begin

process( div_in	)
variable v_div_ten: std_logic_vector(3 downto 0);	-- 4 bit
variable v_div_1: std_logic_vector(6 downto 0);		-- 7 bit

begin
	if(div_in<"0001010") then						-- 10 
		v_div_ten:="0000";					-- 0
		v_div_1:= div_in;
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0);	-- 4bit
	end if;
	
	if(div_in>"0001001" and div_in<"0010100") then
		v_div_ten:="0001";					-- 1
		v_div_1:=div_in-"0001010";		-- 10	
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0);	-- 4bit
	end if;
	
	if(div_in>"0010011" and div_in<"0011110") then	-- 11
		v_div_ten:="0010";					-- 2
		v_div_1:=div_in-"0010100";		-- 20
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0);	-- 4bit
	end if;
	
	if(div_in>"0011101" and div_in<"0101000") then	-- 29 or 28
		v_div_ten:="0011";					-- 3
		v_div_1:=div_in-"0011110";		-- 30			
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0);	-- 4bit
	end if;

	if(div_in>"0100111" and div_in<"0110010") then
		v_div_ten:="0100";					-- 4
		v_div_1:=div_in-"0101000";		-- 40
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;

	if(div_in>"0110001" and div_in<"0111100") then
		v_div_ten:="0101";					-- 5
		v_div_1:=div_in-"0110010";		-- 50
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;
	
	if(div_in>"0111011" and div_in<"1000110") then
		v_div_ten:="0110";					-- 6
		v_div_1:=div_in-"0111100";		-- 60
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;
	
	if(div_in>"1000101" and div_in<"1010000") then
		v_div_ten:="0111";					-- 7
		v_div_1:=div_in-"1000110";		-- 70
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;
	
	if(div_in>"1001111" and div_in<"1011010") then
		v_div_ten:="1000";					-- 8
		v_div_1:=div_in-"1010000";		-- 80
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;

	if(div_in>"1011001" and div_in<"1100100") then
		v_div_ten:="1001";					-- 9
		v_div_1:=div_in-"1011010";		-- 90
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;
	
	if(div_in>"1100011") then			
		v_div_ten:="1111";					-- 15
		v_div_1:="1111111"; 			-- 127			
		div_ten<=v_div_ten;
		div_1<=v_div_1(3 downto 0); -- 4bit
	end if;
end process;

end beh;