Library IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE IEEE.STD_LOGIC_ARITH.ALL;
USE IEEE.STD_LOGIC_UNSIGNED.ALL;

entity DOT_MATRIX is

port ( main_clk2 : in std_logic;
	   sw1 : in std_logic;
	   sw2 : in std_logic;
	   sw3 : in std_logic;
	   sw4 : in std_logic;
	   dotAmPm : in std_logic;
	   dot_scan_sm : out std_logic_vector(9 downto 0);
	   dot_out1_sm : out std_logic_vector(6 downto 0);
	   dot_out2_sm : out std_logic_vector(6 downto 0));
end DOT_MATRIX;

Architecture behav of DOT_MATRIX is

component clk_div
		generic(count : integer range 0 to 655350);
		port(clk_in : in std_logic;
			 sm_clk : out std_logic);
end component;

signal cnt : integer range 0 to 10 := 2;
signal count : std_logic_vector(4 downto 0) := "00000";
signal page_cnt : std_logic_vector(4 downto 0) := "00000";
signal dot_clk : std_logic :='0';

begin
	dot_clk_div : clk_div 
				generic map (count => 6000)
				port map (main_clk2, dot_clk);
				
    process(dot_clk, page_cnt)
    begin
    
    if (dot_clk'event and dot_clk = '1') then
		if (dotAmPm= '0') then --0 for AM
			case cnt is
			WHEN 0 =>
				DOT_SCAN_SM <= "0000000001";
				DOT_OUT1_SM <= NOT "0100101";				
			WHEN 1 =>
				DOT_SCAN_SM <= "0000000010";
				DOT_OUT1_SM <= NOT "1010111";				
			WHEN 2 =>
				DOT_SCAN_SM <= "0000000100";
				DOT_OUT1_SM <= NOT "1010111";				
			WHEN 3 =>
				DOT_SCAN_SM <= "0000001000";
				DOT_OUT1_SM <= NOT "1110101";				
			WHEN 4 =>
				DOT_SCAN_SM <= "0000010000";
				DOT_OUT1_SM <= NOT "1010101";					
			WHEN OTHERS =>
				DOT_SCAN_SM <= "0000000000";
				DOT_OUT1_SM <= "0000000";
				DOT_OUT2_SM <= "0000000";
			END CASE;
			
			if CNT = 4 then
			   CNT <= 0;
			else
			   CNT <= CNT + 1;
			end if;	
						
		elsif (dotAmPm= '1') then --1 for PM
			case cnt is
			WHEN 0 =>
				DOT_SCAN_SM <= "0000000001";
				DOT_OUT1_SM <= NOT "1100101";				
			WHEN 1 =>
				DOT_SCAN_SM <= "0000000010";
				DOT_OUT1_SM <= NOT "1010111";				
			WHEN 2 =>
				DOT_SCAN_SM <= "0000000100";
				DOT_OUT1_SM <= NOT "1010111";				
			WHEN 3 =>
				DOT_SCAN_SM <= "0000001000";
				DOT_OUT1_SM <= NOT "1100101";				
			WHEN 4 =>
				DOT_SCAN_SM <= "0000010000";
				DOT_OUT1_SM <= NOT "1000101";								
			WHEN OTHERS =>
				DOT_SCAN_SM <= "0000000000";
				DOT_OUT1_SM <= "0000000";
				DOT_OUT2_SM <= "0000000";
			END CASE;
			
			if CNT = 4 then
			   CNT <= 0;
			else
			   CNT <= CNT + 1;
			end if;			
		end if;
		
	end if;	
end process;
END behav;