library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity led_dec is
port(	led_in: in std_logic_vector(3 downto 0);
		led_out: out std_logic_vector(7 downto 0));
end led_dec;

architecture beh of led_dec is

begin
process(led_in)
begin
	case led_in is
		when "0000"=>led_out<="00111111";
		when "0001"=>led_out<="00000110";
		when "0010"=>led_out<="01011011"; 
		when "0011"=>led_out<="01001111"; 
		when "0100"=>led_out<="01100110"; 
		when "0101"=>led_out<="01101101";
		when "0110"=>led_out<="01111101"; 
		when "0111"=>led_out<="00100111"; 
		when "1000"=>led_out<="01111111"; 
		when "1001"=>led_out<="01101111";
		when others=>led_out<="00000000"; 
	end case;
end process;

end beh;