library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity mode_gen is
port(	clk: in std_logic;   --FPGA Clock used: 33 MHz
		sw1: in std_logic;
		sw2: in std_logic;
		set: in std_logic;
		mode1: out std_logic_vector(1 downto 0);
		mode2: out std_logic_vector(1 downto 0);
		increase: out std_logic);
end mode_gen;

architecture behav of mode_gen is
			
type state_values is (time1,date,timer,alarm);
signal state, next_state: state_values;
signal v_mode1: std_logic_vector(1 downto 0);
signal v_mode2: std_logic_vector(1 downto 0);
signal inc_cnt: std_logic_vector(4 downto 0);
		
	begin
	process(sw1)
	begin
		if rising_edge(sw1) then
			state<=next_state;
		end if;
	end process;

	process(state) --Chaning state one to other and assigning v_mode1 value
	begin
		case state is
			when time1	=>	v_mode1		<="00";
							next_state	<=date;
			when date 	=>	v_mode1		<="01";
							next_state	<=timer;
			when timer 	=>	v_mode1		<="10";
							next_state	<=alarm;				
			when alarm =>  	v_mode1		<="11";
							next_state <= time1;
		end case;
	end process;

	process(sw1, sw2)  --v_mode2 will be 4 value: 00, 01, 10, 11; serially
	begin

		if(sw1='1') then	
			v_mode2<="00";
		elsif rising_edge(sw2) then
			if(v_mode2="11") then
				v_mode2<="00";
			else
				v_mode2<=v_mode2+1;
			end if;
		end if;
	end process;
	
	mode1<=v_mode1;
	mode2<=v_mode2;

	process(clk, set)
	begin
		if(clk'event and clk='0') then
			if set='1' then inc_cnt<=inc_cnt+1;
			else inc_cnt<="00000";		--inc_count 1/2 bit should work. Check!
			end if;
		end if;
	end process;
			
	process(inc_cnt)
	begin
		if inc_cnt="00001" then 
			increase<='1';
		else 
			increase<='0';
		end if;
	end process;
end behav;