library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity selector is
port(	clk	: in std_logic;
		sw3	: in std_logic;
		increase: in std_logic;
		mode1	: in std_logic_vector(1 downto 0);
		mode2	: in std_logic_vector(1 downto 0);
		hour	: in std_logic_vector(4 downto 0);
		min		: in std_logic_vector(5 downto 0);
		sec		: in std_logic_vector(5 downto 0);
		year	: in std_logic_vector(6 downto 0);
		mon		: in std_logic_vector(3 downto 0);
		day		: in std_logic_vector(5 downto 0);
		min_sw	: in std_logic_vector(5 downto 0);
		sec_sw	: in std_logic_vector(5 downto 0);
		secc_sw	: in std_logic_vector(6 downto 0);
		out_h 	: out std_logic_vector(6 downto 0);
		out_m	: out std_logic_vector(6 downto 0);
		out_s	: out std_logic_vector(6 downto 0);
		
		sel_out_ledr : out std_logic_vector (7 downto 0);
		sel_out_buzzer: out std_logic
				
		);
		
end selector;

architecture behav of selector is
signal hur_al	: std_logic_vector(4 downto 0):="00000"; --00
signal min_al	: std_logic_vector(5 downto 0):="001010"; --00
signal sw3_off	:std_logic:='0';
signal s_ledr 	: std_logic_vector(7 downto 0):="11111111";

begin

process(clk, mode1, mode2, hour, min, sec, year, mon, day, sec_sw, secc_sw, hur_al, min_al)

begin
	if rising_edge (clk) then
		if(mode1="00") then		--Jam
			case mode2 is
				when "00"=>				--[00]
					out_h<="00"&hour;
					out_m<='0'&min;
					out_s<='0'&sec;
				when "01"=>				--[01]
					out_h<="00"&hour;
					out_m<="1111111";
					out_s<="1111111";
				when "10"=>				--[10]
					out_h<="1111111";
					out_m<='0'&min;
					out_s<="1111111";
				when others=> 			--[11]
					out_h<="00"&hour;
					out_m<='0'&min;
					out_s<='0'&sec;
			end case;
		elsif( mode1="01") then	--Hari
			case mode2 is
				when "00"=>
					out_h<=year;
					out_m<="000"&mon;
					out_s<="0"& day;
				when "01"=>
					out_h<=year;
					out_m<="1111111";
					out_s<="1111111";
				when "10"=>
					out_h<="1111111";
					out_m<="000"&mon;
					out_s<="1111111";
				 when others=>	--11
					out_h<="1111111";
					out_m<="1111111";
					out_s<="0"&day;
			end case;
			
		elsif(mode1="10") then 			--Timer 
			out_h<='0'&min_sw;	
			out_m<='0'&sec_sw; 
			out_s<=secc_sw;
			
		elsif(mode1="11") then			--Alarm
			case mode2 is
				when "00"=>
					out_h<="00"&hur_al;
					out_m<='0'&min_al;
					out_s<="1111111";
				when "01"=>
					out_h<="00"&hur_al;
					out_m<="1111111";
					out_s<="1111111";
				when "10"=>
					out_h<="1111111";
					out_m<='0'&min_al;
					out_s<="1111111";
				when others=>
					out_h<="00"&hur_al;
					out_m<='0'&min_al;
					out_s<="1111111";
			end case;
			
		end if;
	end if;
end process;
				
process(increase, mode1, mode2, hur_al, min_al, hour, min)
variable al_state: std_logic; 				--*-- 

begin 
	if rising_edge(increase) then
		if(mode1="11") then
			if(mode2="01")then
				if(hur_al="01100") then		--[12]
					hur_al<="00000";
				else
					hur_al<=hur_al+1;
				end if;
			elsif(mode2="10") then
				if(min_al="111011") then	--[59]
					min_al<="000000";
				else
					min_al<=min_al+1;
				end if;
			else
				null;						--for mode2 11/00 >> nothing will happen
			end if;
		end if;
	end if;
	
end process;

process (clk)
begin
if rising_edge (clk) then
	if hur_al=hour and min_al=min then
		s_ledr<="00000000"; sel_out_buzzer<='1';
	else
		s_ledr<="11111111"; sel_out_buzzer<='0';
	end if;
	sel_out_ledr<=s_ledr; 
	 
end if;
end process;

end	behav;