library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity TIMER is
port(	clk: in std_logic;
			sw3: in std_logic;
			mode1: in std_logic_vector(1 downto 0);
			mode2: in std_logic_vector(1 downto 0);
			min_sw: out std_logic_vector(5 downto 0);
			sec_sw: out std_logic_vector(5 downto 0);
			secc_sw: out std_logic_vector(6 downto 0));
end TIMER;


architecture behav of TIMER is 

--signal inc_min:std_logic;
signal temp: std_logic_vector(1 downto 0):="00";
signal temp2: std_logic_vector(1 downto 0):="00";

begin

process(sw3)
begin
	if (rising_edge(sw3)) then
	--if (falling_edge(sw3)) then
	--if (sw3='1') then
		case mode1 is
		when "10" 	=> 	if (temp="11") then temp<="00";		
						else
							temp<=temp+1;
						end if;
						temp2<="00";
						
		when others => 	temp2<="11";
		--nothing to do for other modes
		end case;
	end if;
end process;

process(clk, temp, temp2)
variable v_secc: std_logic_vector(6 downto 0):="0000000";
variable v_sec: std_logic_vector(5 downto 0):="000000";
variable v_min: std_logic_vector(5 downto 0):="000000";


begin

if rising_edge(clk) and (temp="01" or temp="11") then
		v_secc:=v_secc+1;
		if(v_secc="1100100") then	--100
			v_sec:=v_sec+1;
			v_secc:="0000000";		
			if(v_sec="111100") then	--60
				v_min:=v_min+1;
				v_sec:="000000";	
				if(v_min="111100") then	--60
					v_min:="000000";
				end if;
			end if;
		end if;
						
		min_sw<=v_min;
		sec_sw<=v_sec;
		secc_sw<=v_secc;
		
elsif rising_edge(clk) and temp="10" then	

		--Nothing to do but PAUSE		
		min_sw<=v_min;
		sec_sw<=v_sec;
		secc_sw<=v_secc;

elsif rising_edge(clk) and temp="00" then	

		--Nothing to do but STOP and set variable to Zero		
		min_sw<=v_min;
		sec_sw<=v_sec;
		secc_sw<=v_secc;
		
		v_min:="000000";
		v_sec:="000000";
		v_secc:="0000000";
		
elsif rising_edge(clk) and temp2="11" then			
		--Nothing to do. Just timer continues its previous step.

end if;	
end process;
end behav;