library ieee;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity top is
port(	clk_org: in std_logic;
		sw1: in std_logic;
		sw2: in std_logic;
		sw3: in std_logic;	--- Why Input SW3. We have to use only SW1, 2 and SET
		set: in std_logic;
		fnd_out: out std_logic_vector(7 downto 0);
		fnd_sel: out std_logic_vector(5 downto 0);
		dot_scan_sm : out std_logic_vector(9 downto 0);
		dot_out1_sm : out std_logic_vector(6 downto 0);
		dot_out2_sm : out std_logic_vector(6 downto 0);
		-- out_buzzer: out std_logic:='1'
		out_ledr: out std_logic_vector(7 downto 0);
		out_biner: out std_logic_vector(7 downto 0)
		);
		
end top;

architecture HL of top is

--signal

component MODE_GEN
	port(	clk: in std_logic;
			sw1: in std_logic;
			sw2: in std_logic;
			set: in std_logic;
			mode1: out std_logic_vector(1 downto 0);
			mode2: out std_logic_vector(1 downto 0);
			increase: out std_logic);
end component;

component D_TIME
	port(	clk: in std_logic;	
			mode1: in std_logic_vector(1 downto 0);
			mode2: in std_logic_vector(1 downto 0);
			increase: in std_logic;
			hour: out std_logic_vector(4 downto 0);
			min: out std_logic_vector(5 downto 0);
			sec: out std_logic_vector(5 downto 0);
			dotAmPm: out std_logic;
			hur_carry: out std_logic);
end component;

component DOT_MATRIX
	port ( 	main_clk2 : in std_logic;
			dotAmPm : in std_logic;
			dot_scan_sm : out std_logic_vector(9 downto 0);
			dot_out1_sm : out std_logic_vector(6 downto 0);
			dot_out2_sm : out std_logic_vector(6 downto 0));
end component;

component CLK_DIV
	generic(COUNT: INTEGER range 0 to 655350);
	port (	
			CLK_IN	: in std_logic; 
			SM_CLK	: out std_logic);
end component;
	
component D_DATE
	port(	clk: in std_logic;
			mode1: in std_logic_vector(1 downto 0);
			mode2: in std_logic_vector(1 downto 0);
			increase: in std_logic;
			hur_carry: in std_logic;
			year: out std_logic_vector(6 downto 0);
			mon: out std_logic_vector(3 downto 0);
			day: out std_logic_vector(5 downto 0));
end component;

component TIMER
	port(	clk: in std_logic;
			sw3: in std_logic;
			mode1: in std_logic_vector(1 downto 0);
			mode2: in std_logic_vector(1 downto 0);
			min_sw: out std_logic_vector(5 downto 0);
			sec_sw: out std_logic_vector(5 downto 0);
			secc_sw: out std_logic_vector(6 downto 0));
end component;

component SELECTOR
	port(	clk: in std_logic;
			sw3: in std_logic;
			mode1: in std_logic_vector(1 downto 0);
			mode2: in std_logic_vector(1 downto 0);
			increase : in std_logic;
			
			hour: in std_logic_vector(4 downto 0);
			min: in std_logic_vector(5 downto 0);
			sec: in std_logic_vector(5 downto 0);
			
			year: in std_logic_vector(6 downto 0);
			mon: in std_logic_vector(3 downto 0);
			day: in std_logic_vector(5 downto 0);
			
			min_sw: in std_logic_vector(5 downto 0);
			sec_sw: in std_logic_vector(5 downto 0);
			secc_sw: in std_logic_vector(6 downto 0);
			
			out_h: out std_logic_vector(6 downto 0);
			out_m: out std_logic_vector(6 downto 0);
			out_s: out std_logic_vector(6 downto 0);
			
			--sel_out_buzzer: out std_logic
			sel_out_ledr: out std_logic_vector (7 downto 0)
			);
end component;

component DIVIDER
	port(	div_in: in std_logic_vector(6 downto 0);
			div_ten: out std_logic_vector(3 downto 0);
			div_1: out std_logic_vector(3 downto 0));
end component;

component LED_DEC
	port(	led_in: in std_logic_vector(3 downto 0);	--change from 4 to 8 bit
			led_out: out std_logic_vector(7 downto 0));
end component;

component CLOCK
port (CLKIN : in std_logic;
      CLKOUT : out std_logic);
end component;


signal  cnt_1 : std_logic_vector(11 downto 0);--13 downto 0
signal  cnt : integer;
signal  s_clk : std_logic;--
signal  s_dotclk : std_logic;--

signal	tmp_mod1, tmp_mod2: std_logic_vector(1 downto 0);
signal	tmp_inc: std_logic;

signal	tmp_h: std_logic_vector(4 downto 0);
signal	tmp_m, tmp_s, timer_min, timer_sec: std_logic_vector(5 downto 0);
signal	tmp_carry: std_logic;
signal	tmp_dotampm: std_logic;
signal	timer_secc:std_logic_vector(6 downto 0);
	
signal	toDiv_h, toDiv_s: std_logic_vector(6 downto 0);
signal	toDiv_m: std_logic_vector(6 downto 0);
signal  toSel_year: std_logic_vector(6 downto 0);
signal	toSel_mon: std_logic_vector(3 downto 0);
signal	toSel_day: std_logic_vector(5 downto 0);

signal	out_hH, out_hL, out_mH, out_mL, out_sH, out_sL: std_logic_vector(3 downto 0);

signal  led_out1, led_out2, led_out3, led_out4, led_out5, led_out6 : std_logic_vector(7 downto 0);

signal  dotScan: std_logic_vector(9 downto 0);
signal	dotOut1: std_logic_vector(6 downto 0);
signal	dotOut2: std_logic_vector(6 downto 0);

--signal s_buzzer: std_logic;
signal s_ledr: std_logic_vector(7 downto 0);
signal s_biner: std_logic_vector(7 downto 0); 

begin
process(clk_org)
begin
	if rising_edge(clk_org) then
		if cnt_1="111111111111" then --11111111111111
			cnt_1<="000000000000"; --00000000000000
		else
			cnt_1<=cnt_1+1;
		end if;
	end if;
end process;

process(cnt_1)
begin
	case cnt_1(11 downto 9)is
		when "000"=>fnd_sel<="111110";
					fnd_out<=led_out1;
		when "001"=>fnd_sel<="111101";
					fnd_out<=led_out2;
		when "010"=>fnd_sel<="111011";
					fnd_out<=led_out3;
		when "011"=>fnd_sel<="110111";
					fnd_out<=led_out4;
		when "100"=>fnd_sel<="101111";
					fnd_out<=led_out5;
		when "101"=>fnd_sel<="011111";
					fnd_out<=led_out6;
		when others=>fnd_sel<=(others=>'1');
					fnd_out<=(others=>'0');
		end case;
		
end process;

--out_buzzer<=s_buzzer;
out_ledr<=s_ledr;
dot_scan_sm<=dotscan;
dot_out1_sm<=dotout1;
dot_out2_sm<=dotout2;


U0: MODE_GEN
port map(	clk=>s_clk, sw1=>sw1, sw2=>sw2, set=>set,
			mode1=>tmp_mod1, mode2=>tmp_mod2, increase=>tmp_inc); --(port=>signal this way)
U1: D_TIME
port map(	clk=>s_clk, mode1=>tmp_mod1, mode2=>tmp_mod2, increase=>tmp_inc,
			hour=>tmp_h, min=>tmp_m, sec=>tmp_s, hur_carry=>tmp_carry,
			dotAmPm=>tmp_dotAmPm);
U3: D_DATE
port map (	clk=>s_clk, mode1=>tmp_mod1, mode2=>tmp_mod2, increase=>tmp_inc, hur_carry=>tmp_carry,
		year=>toSel_year, mon=>toSel_mon, day=>toSel_day);

U4: TIMER
port map (	clk=>s_clk, sw3=>sw3, mode1=>tmp_mod1, mode2=>tmp_mod2, 
			min_sw=>timer_min, sec_sw=>timer_sec, secc_sw=>timer_secc);		



U5: SELECTOR --mon, day, min_sw, sec_sw, secc_sw
port map(	clk=>s_clk, sw3=>sw3, mode1=>tmp_mod1, mode2=>tmp_mod2, increase=>tmp_inc, 
			hour=>tmp_h, min=>tmp_m, sec=>tmp_s, year=>toSel_year, mon=>toSel_mon, 
			day=>toSel_day, 
			min_sw=>timer_min, sec_sw=>timer_sec, secc_sw=>timer_secc,
			out_h=>toDiv_h, out_m=>toDiv_m, out_s=>toDiv_s ,sel_out_ledr=>s_ledr --,sel_out_buzzer=>s_buzzer
			);--
U6: DIVIDER
port map(	div_in=>toDiv_h,
			div_ten=>out_hH, div_1=>out_hL);
U7: DIVIDER
port map(	div_in=>toDiv_m,
			div_ten=>out_mH, div_1=>out_mL);
U8: DIVIDER
port map(	div_in=>toDiv_s,
			div_ten=>out_sH, div_1=>out_sL);
U9: LED_DEC
port map(	led_in=>out_hH,
			led_out=>led_out1);
U10: LED_DEC
port map(	led_in=>out_hL,
			led_out=>led_out2); 			
U11: LED_DEC
port map(	led_in=>out_mH,
			led_out=>led_out3);
U12: LED_DEC
port map(	led_in=>out_mL,
			led_out=>led_out4);
U13: LED_DEC
port map(	led_in=>out_sH,
			led_out=>led_out5);
U14: LED_DEC
port map(	led_in=>out_sL,
			led_out=>led_out6);	
U15: CLOCK
port map(	CLKIN=>clk_org,
			CLKOUT=>s_clk);
U16: CLK_DIV
generic map (COUNT =>1)
port map(	CLK_IN=>clk_org,
		    SM_CLK=>s_dotclk);

U17: DOT_MATRIX
port map(	main_clk2=>s_dotclk,
			dotAmPm=>tmp_dotAmPm,
			dot_scan_sm=>dotscan,
			dot_out1_sm=>dotout1,
			dot_out2_sm=>dotout2);
end HL;	