library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity example_fnd is
	Port(clock : in STD_LOGIC;
	SEG_A, SEG_B, SEG_C, SEG_D : out STD_LOGIC;
	SEG_E, SEG_F, SEG_G, SEG_DP : out STD_LOGIC;
	DIGIT : out STD_LOGIC_VECTOR( 5 downto 0 ));
end example_fnd;

architecture Behavioral of example_fnd is
	signal seg_int : std_logic_vector (7 downto 0);
	signal count : std_logic_vector (9 downto 0);
	signal seg_in : std_logic_vector (3 downto 0);
begin
	process(clock)
	begin
		if clock'event and clock = '1' then
			count <= count + '1';
		end if;
	end process;
	
	process(clock, count(9 downto 7))
	begin
		if clock'event and clock = '1' then
			case count(9 downto 7) is
				when "000" => seg_in <= "0001"; DIGIT <= "111110";
				when "001" => seg_in <= "0010"; DIGIT <= "111101";
				when "010" => seg_in <= "0011"; DIGIT <= "111011";
				when "011" => seg_in <= "0100"; DIGIT <= "110111";
				when "100" => seg_in <= "0101"; DIGIT <= "101111";
				when "101" => seg_in <= "0110"; DIGIT <= "011111";
				when others => seg_in <= "0000"; DIGIT <= "111111";
			end case;
		end if;
	end process;
	process(seg_in)
	begin
	 case seg_in is
		when "0000" => seg_int <= "00111111";
		when "0001" => seg_int <= "00000110";
		when "0010" => seg_int <= "01011011";
		when "0011" => seg_int <= "01001111";
		when "0100" => seg_int <= "01100110";
		when "0101" => seg_int <= "01101101";
		when "0110" => seg_int <= "01111101";
		when "0111" => seg_int <= "00100111";
		when "1000" => seg_int <= "01111111";
		when "1001" => seg_int <= "01101111";
		when others => seg_int <= "00000000";
	 end case;
	end process;
	
	
	SEG_A <= seg_int(0); SEG_B <= seg_int(1);
	SEG_C <= seg_int(2); SEG_D <= seg_int(3);
	SEG_E <= seg_int(4); SEG_F <= seg_int(5);
	SEG_G <= seg_int(6); SEG_DP <= seg_int(7);
end Behavioral;
